<?php if(get_setting('home_categories') != null): ?>
    <?php
        $home_categories = json_decode(get_setting('home_categories'));
        $categories = get_category($home_categories);
    ?>
    <?php if(count($categories) > 0): ?>
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category_key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $category_name = $category->getTranslation('name');
            ?>
            <section class="py-3" style="">
                <div class="container">
                    <div class="border">
                        <!-- Title -->
                        <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0 mt-3 px-3 px-sm-4">
                            <span class=""><?php echo e($category_name); ?></span>
                        </h3>
                        <div class="d-sm-flex bg-white">
                            <!-- Home category banner & name -->
                            <div class="px-0 pt-0 pb-3 p-sm-4">
                                <div class="w-sm-260px h-260px mx-auto">
                                    <a href="<?php echo e(route('products.category', $category->slug)); ?>" class="d-block h-100 w-100 w-xl-auto hov-scale-img overflow-hidden home-category-banner">
                                        <span class="position-absolute h-100 w-100 overflow-hidden">
                                            <img src="<?php echo e(isset($category->coverImage->file_name) ? my_asset($category->coverImage->file_name) : static_asset('assets/img/placeholder.jpg')); ?>"
                                                alt="<?php echo e($category_name); ?>"
                                                class="img-fit h-100 has-transition"
                                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                        </span>
                                    </a>
                                </div>
                            </div>
                            <!-- Category Products -->
                            <div class="p-0 p-sm-4 w-100 overflow-hidden">
                                <div class="aiz-carousel arrow-x-0 arrow-inactive-none" data-items="5"
                                    data-xxl-items="5" data-xl-items="3.5" data-lg-items="3" data-md-items="2" data-sm-items="1"
                                    data-xs-items="2" data-arrows='true' data-infinite='false'>
                                    <?php $__currentLoopData = get_cached_products($category->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="carousel-box px-3 position-relative has-transition hov-animate-outline">
                                            <?php echo $__env->make('frontend.'.get_setting('homepage_select').'.partials.product_box_2', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/mmflimui/tea.mmflix.live/resources/views/frontend/minima/partials/home_categories_section.blade.php ENDPATH**/ ?>