

<?php $__env->startSection('meta_title'); ?><?php echo e($shop->meta_title); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta_description'); ?><?php echo e($shop->meta_description); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="<?php echo e($shop->meta_title); ?>">
    <meta itemprop="description" content="<?php echo e($shop->meta_description); ?>">
    <meta itemprop="image" content="<?php echo e(uploaded_asset($shop->logo)); ?>">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="<?php echo e($shop->meta_title); ?>">
    <meta name="twitter:description" content="<?php echo e($shop->meta_description); ?>">
    <meta name="twitter:creator" content="@author_handle">
    <meta name="twitter:image" content="<?php echo e(uploaded_asset($shop->meta_img)); ?>">

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($shop->meta_title); ?>" />
    <meta property="og:type" content="Shop" />
    <meta property="og:url" content="<?php echo e(route('shop.visit', $shop->slug)); ?>" />
    <meta property="og:image" content="<?php echo e(uploaded_asset($shop->logo)); ?>" />
    <meta property="og:description" content="<?php echo e($shop->meta_description); ?>" />
    <meta property="og:site_name" content="<?php echo e($shop->name); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $total = 0;
        $rating = 0;
        foreach ($shop->user->products as $key => $seller_product) {
            $total += $seller_product->reviews->where('status', 1)->count();
            $rating += $seller_product->reviews->where('status', 1)->sum('rating');
        }
    ?>

    <section class="py-5 mb-4 bg-white">
        <div class="container">
            <div class="row">
                <div class="col-md-6 mx-auto">
                    <div class="d-flex justify-content-center">
                        <!-- Shop Logo -->
                        <a href="<?php echo e(route('shop.visit', $shop->slug)); ?>" class="overflow-hidden size-64px rounded-content" style="border: 1px solid #e5e5e5;
                            box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.06);min-width: fit-content;">
                            <img class="lazyload h-64px  mx-auto"
                                src="<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>"
                                data-src="<?php echo e(uploaded_asset($shop->logo)); ?>"
                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                        </a>
                        <div class="ml-3">
                            <!-- Shop Name & Verification Status -->
                            <a href="<?php echo e(route('shop.visit', $shop->slug)); ?>"
                                class="text-dark d-block fs-16 fw-700">
                                <?php echo e($shop->name); ?>

                                <span class="ml-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17.5" height="17.5" viewBox="0 0 17.5 17.5">
                                        <g id="Group_25616" data-name="Group 25616" transform="translate(-537.249 -1042.75)">
                                            <path id="Union_5" data-name="Union 5" d="M0,8.75A8.75,8.75,0,1,1,8.75,17.5,8.75,8.75,0,0,1,0,8.75Zm.876,0A7.875,7.875,0,1,0,8.75.875,7.883,7.883,0,0,0,.876,8.75Zm.875,0a7,7,0,1,1,7,7A7.008,7.008,0,0,1,1.751,8.751Zm3.73-.907a.789.789,0,0,0,0,1.115l2.23,2.23a.788.788,0,0,0,1.115,0l3.717-3.717a.789.789,0,0,0,0-1.115.788.788,0,0,0-1.115,0l-3.16,3.16L6.6,7.844a.788.788,0,0,0-1.115,0Z" transform="translate(537.249 1042.75)" fill="red"/>
                                        </g>
                                    </svg>
                                </span>
                            </a>
                            <!-- Ratting -->
                            <div class="rating rating-mr-2 text-dark">
                                <?php echo e(renderStarRating($shop->rating)); ?>

                                <span class="opacity-60 fs-12">(<?php echo e($shop->num_of_reviews); ?>

                                    <?php echo e(translate('Reviews')); ?>)</span>
                            </div>
                            <!-- Address -->
                            <div class="location fs-12 opacity-70 text-dark mt-1"><?php echo e($shop->address); ?></div>
                            <!-- Member Since -->
                            <div class="mt-3">
                                <div class="fs-10 fw-400 text-secondary"><?php echo e(translate('Member Since')); ?></div>
                                <div class="fs-16 fw-700 text-secondary"><?php echo e(date('d M Y',strtotime($shop->created_at))); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="mb-4">
        <div class="container">
            <div class="row">
                <div class="col-xxl-5 col-xl-6 col-md-8 mx-auto">
                    <div class="bg-white border p-4 text-center">
                        <h3 class="fw-600 fs-20">
                            <?php echo e($shop->user->name); ?> <?php echo e(translate('has not been verified yet.')); ?>

                        </h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmflimui/laomanetea.com/resources/views/frontend/seller_shop_without_verification.blade.php ENDPATH**/ ?>